#include "bdtypes.h"
#include "bdfunc.h"
#include "bdglobal.h"
#include "effects.h"

// needed for splash screen
#include "scorpion.h"

//#define __SHOT__
//#define __NO_SOUND__
#define __NO_VIDEO__

void ShowSplashScreen(){
	GrVertex Fond1 = {0.f,0.f,1,  255,128,128,   0,128.f,1.f/1,{0,0, 1.f/1}};
	GrVertex Fond2 = {640.f,0,1,   128,255,128,   0,128.f,1.f/1,{256.f/1,0,1.f/300.f}};
	GrVertex Fond3 = {640.,480.,1,   64,64,192,   0,128.f,1.f/1,{256.f/1,256.f/1,1.f/1}};
	GrVertex Fond4 = {0,480.,1,   64,64,192,   0,128.f,1.f/1,{0,256.f/1,1.f/1}};
	Picture SplashPic;
	JpegTexture SplashTex;
	
	SplashPic = LoadJpeg2Array(Splash, NULL, NULL);
	PrepareTextureFromArray(SplashPic, 256, 256, &SplashTex);
	DownloadTexture(&SplashTex);
	SelectTexture(SplashTex);
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_DISABLE);
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);
	grBufferSwap(1);
	grBufferClear(0,255,GR_WDEPTHVALUE_FARTHEST);
	FreeTexture(&SplashTex);
	free(SplashPic);
}

//////////////////////////////////////////////////////////
// Code
//////////////////////////////////////////////////////////

// System dependant

// Win32
#ifdef WIN32

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
		LPSTR lpCmdLine,int nShowCmd)
{

	MSG msg;
	DWORD ThreadId;

// ANSI
#else

int main(int argc, char *argv[])
{

#endif

// End System dependant

//////////////////////////////////////////////////////////
// Program start here
//////////////////////////////////////////////////////////

	unsigned int Cpt1;
	long tmp;
	int OldMidasEvent = -2;
#ifdef __SHOT__
	BOOL bShot = FALSE;
#endif

//////////////////////////////////////////////////////////
// Inits
//////////////////////////////////////////////////////////


	// if Win32, create a window
#ifdef WIN32
	Setup(hInstance);
	if (InitWindow(hInstance)==false)
	{
		ErrorMessage("Unable to create a window");
	}

	SetPriorityClass(GetCurrentProcess(), g_demostate.dwPriority);

	// if Unix, bind a function to SIGINT
#else
	Setup();
	signal(SIGINT, repSIGINT);
#endif

#ifdef __NO_SOUND__
	g_demostate.NoSoundMode = true;
#endif

	//grGlideInit();
	// Init Voodoo
	fprintf(stderr, "Initing Voodoo\n");
	if (HardInit()==FALSE)
	{
		ModuleShutDown();
		return 1;
	}

	ShowSplashScreen();		

#ifdef _DEBUG
	grSstControl(GR_CONTROL_DEACTIVATE);
#endif

	// Start the music
	fprintf(stderr, "Initing music\n");
	if (g_demostate.NoSoundMode == false)
	{
		if (g_demostate.VideoFlo)
			InitModule(g_szVideoModulename);
		else
			InitModule(g_szModulename);
		if (g_demostate.musicstate != MusicLoadModule)
		{
		  ShutDown();
		  ErrorMessage("Unable to init music; device busy ? You should stop Winamp :-)");
		  return 0;
		}
	}

	LoadPictures();
	ComputeTables();

	// Init each effect
	fprintf(stderr, "Init each effect\n");
	for(Cpt1=0;Cpt1<g_NbEffects;Cpt1++)
	{
		g_timing[Cpt1].LInit();
	}

//////////////////////////////////////////////////////////
// It is to start...
//////////////////////////////////////////////////////////

	// Play the module
	fprintf(stderr, "Starting module\n");
	if (g_demostate.NoSoundMode == false)
	{
		g_demostate.playHandle = MIDASplayModule(g_demostate.module, FALSE);
		if (g_demostate.playHandle==0)
		{
			ModuleShutDown();
			ShutDown();
			ErrorMessage("Unable to play music");
			return 0;
		}
		MIDASsetMusicVolume(g_demostate.playHandle, 64);
	}

	fprintf(stderr, "We have %d effects\n", g_NbEffects);
	printf("Here we go!\n");

#ifdef WIN32
	__asm{
		finit // initialize the FPU
		fwait // wait for operation to complete
		fstcw [tmp] // store FPU control word to memvar
		fwait // wait for operation to complete
		mov eax, [tmp] // move memvar to a register
		and eax, 0xfffffcff // mask off precision => 24-bit prec
		mov [tmp], eax // save control word to memory
		fldcw [tmp] // load control word back to FPU
		fwait // wait for operation to complete
	}
#else
	__asm__ __volatile__ ("
	pushl %%eax
        finit
        fwait
        fstcw %0
        fwait
        mov %0, %%eax
        and $4294966527, %%eax
        mov %%eax, %0
        fldcw %0
        fwait
	popl %%eax"
	:
	: "g" (tmp)
	);

#endif

#ifdef _DEBUG
	//grSstControl(GR_CONTROL_ACTIVATE);
#endif
	
	if (g_demostate.VideoFlo){
		DWORD VideoStart = Tick();

		QInit_Video();
		while(g_demostate.bDemoLoop){
#ifdef WIN32
			if(PeekMessage(&msg,g_demostate.hwnd,0,0,PM_NOREMOVE)){
				if(!GetMessage(&msg, g_demostate.hwnd, 0, 0))
					return msg.wParam;
				if (!IsDialogMessage(g_demostate.hwnd, &msg))
				{
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
				continue;
			}
#endif
			g_demostate.TickInEffect = Tick() - VideoStart;
			if (g_demostate.TickInEffect>58000)
				break;
			Effect_Video();
			grBufferSwap(1);
			grBufferClear(g_demostate.ClearColor,255,GR_WDEPTHVALUE_FARTHEST);		
		}
		ByeBye_Video();
	}

	g_demostate.BeginTick = Tick();

//////////////////////////////////////////////////////////
// The Great Loop
//////////////////////////////////////////////////////////

	while(g_demostate.bDemoLoop)
	{
		DWORD nFrame = 0;

#ifdef WIN32
		if(PeekMessage(&msg,g_demostate.hwnd,0,0,PM_NOREMOVE)){
			if(!GetMessage(&msg, g_demostate.hwnd, 0, 0))
				return msg.wParam;
			if (!IsDialogMessage(g_demostate.hwnd, &msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
			continue;
		}
#endif

		MIDASgetPlayStatus(g_demostate.playHandle, &g_demostate.midas_status);
		g_demostate.ThisTick = Tick() - g_demostate.BeginTick;
		if (g_demostate.PreviousPattern != g_demostate.midas_status.position)
		{
			g_demostate.PreviousPattern = g_demostate.midas_status.position;
			g_demostate.StartOfPattern = g_demostate.ThisTick;
		}
		g_demostate.TickInPattern = g_demostate.ThisTick - g_demostate.StartOfPattern;
		if (MK_PAT(g_demostate.midas_status.position, 0)
			>= g_timing[g_demostate.CurrEffect].PatternMax)
		{
			g_timing[g_demostate.CurrEffect].ByeBye();
			g_demostate.CurrEffect++;
			if (g_demostate.CurrEffect>=g_NbEffects)
			{
				break;
			}
			g_timing[g_demostate.CurrEffect].QInit();
			g_demostate.StartOfEffect = g_demostate.ThisTick;
#ifdef __SHOT__
			bShot=FALSE;
#endif
		}

		g_demostate.TickInEffect = g_demostate.ThisTick - g_demostate.StartOfEffect;

		g_timing[g_demostate.CurrEffect].Effect();
		g_demostate.Frame++;

#ifdef __SHOT__
		if ((bShot==FALSE)&&(g_demostate.TickInEffect>1512)){
			Save_Screen();
			bShot=TRUE;
		}
#endif

		grBufferSwap(1);
		grBufferClear(g_demostate.ClearColor,255,GR_WDEPTHVALUE_FARTHEST);		
	}

 fin:

	g_demostate.EndTick = Tick();
#ifndef WIN32
	printf("Framerate : %f\n", g_demostate.Frame * 1000.f / (g_demostate.EndTick-g_demostate.BeginTick));
#else
	{
		char szBuff[30];
		sprintf(szBuff, "Framerate : %f\n", g_demostate.Frame * 1000.f / (g_demostate.EndTick-g_demostate.BeginTick));
		OutputDebugString(szBuff);
	}
#endif
	ShutDown();
#ifdef WIN32
	MessageBox(g_demostate.hwnd, "Why do not try Linux version", 
		"It s a good day to register!", MB_OK|MB_ICONINFORMATION);
#endif

	return 0;
}
